
<?php get_header(); ?>
<div id="bannerTitle" style="background-image: url(<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/blog-cover.jpg);">
    <div class="container">
        <h1><?php $category = get_the_category(); echo $category[0]->cat_name; ?></h1>
        <div class="breadcrumb-sahanala">
            <ul>
                <?php Sahanala::_RenderBreadCrumb(); ?>
            </ul>
        </div>
    </div>
</div>

<div id="internalPage" class="p-0 singlePost">
    <?php if (have_posts()) : ?>
      
          <div class="page-interne-content container pt-5 pb-5 mt-5 mb-5">
                <div class="row">
                    <div class="col-12">
                        <h3><?= pll__("News and updates"); ?><span>.</span></h3>
						<p><?= pll__("Featured stories across the Sahanala family of collaborators, funds, communities and programs."); ?></p>
                    </div>
                    <?php while (have_posts()) : the_post(); ?>
                    <div class="col-sm-4 categoryList">
                        <div class="newsItem">
                            <?php if ( has_post_thumbnail() ) : ?>
                                <a href="<?= get_the_permalink();?>"><span class="img-news" style="background-image: url('<?= get_the_post_thumbnail_url(get_the_ID(),"actus-home"); ?>');"></span></a>
                            <?php else: ?>
                                <a href="<?= get_the_permalink();?>"><span class="img-news" style="background-image: url('<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/placeholder.jpg');"></span></a>
                            <?php endif; ?>
                            
                            <h5><a href="<?= get_the_permalink();?>"><?php the_title()?></a></h5>
                            <?php
                                $trimmed =  wp_trim_words(get_the_content(), 20, ' [...]');
                            ?>
                            <p class="chapo"><?=  $trimmed; ?></p>
                            <p>
                                <a href="<?= get_the_permalink();?>" class="full-blog-btn"><?= pll__("Full story"); ?></a>
                            </p>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
          </div>
        
    <?php endif; ?>
    <?php if (have_posts()) : ?>
		<div class="pagination_category row">
            <div class="container">
                <div class="col-12">
                    <div class="paginateResult">
                        <?php
                        $args = array(
                            'prev_next' => True,
                            'prev_text' => __('&laquo;'),
                            'next_text' => __('&raquo;'),
                            'add_fragment' => '',
                            'before_page_number' => '',
                            'after_page_number' => '',
                            'type' => 'list');
                        echo paginate_links($args);
                        ?>
                    </div>
                </div>
            </div>
			
		</div> 
		<?php endif; ?>
</div>
<?php get_footer(); ?>