<?php 


/**
* Class Sahanala
* Classe qui affiche les views du site.
*/
class Sahanala 
{
    
    public function __construct() {
    }

    
    public static  function socialMediaLink($field)
    {
        # code...
        $params = array("limit" => 1);

        // Nouvelle instance de pods
        $pods = pods("social_media_theme", $params);
        


        if ($pods->total() > 0) {
            $social_media_theme = $pods->display($field);
        }


        return $social_media_theme;
    }

    public static  function _getHomeContent($field)
    {
        # code...

        $params = array("limit" => 1);

        // Nouvelle instance de pods
        $pods = pods("homepage", $params);
        

        $content = "";
        if ($pods->total() > 0) {
            $content = $pods->display($field);
        }


        return $content;
    }


    public static  function contactInformations($field)
    {
        # code...
        $params = array("limit" => 1);

        // Nouvelle instance de pods
        $pods = pods("information_de_contact", $params);
        


        if ($pods->total() > 0) {
            $footerInfos = $pods->display($field);
        }


        return $footerInfos;
    }



    public static  function _getLogoSite()
    {
        # code...
        $url = Sahanala::_getDynamicTranslatedURL('home');

        if ( has_custom_logo() ) {

            $logo = wp_get_attachment_image_src( get_theme_mod( 'custom_logo' ) , 'full' );

            echo '<a class="sahanala-logo-link" href="' . $url . '" >';
            echo '<img class="sahanala-logo" src="' . esc_url( $logo[0] ) . '" width="' . $logo[1] . '" height="' . $logo[2] . '" alt="' . get_bloginfo( 'name' ) . '">';
            echo "</a>";

        } else {

            echo '<h1>';
            echo '<a href="' . $url . '">' . get_bloginfo( 'name' ) . '</a>';
            echo '</h1>';
            
        }
    }


    public static  function _getDynamicTranslatedURL($slug)
    {
        # code...
        $langue_current_site = pll_current_language();
        $post = get_page_by_path( $slug );
        //var_dump($post); exit;
        switch ($langue_current_site) {
            case 'en':
                // code...
                $link = get_permalink(get_page_by_path( $slug ));
                break;

            case 'fr':
                // code...
                $link = get_permalink(pll_get_post( $post->ID ));
                break;
            
            default:
                // code...
                break;
        }

        return $link;
    }


    public static  function _getBlogUrl()
    {
        # code...
        $langue_current_site = pll_current_language();
        //var_dump($post); exit;
        switch ($langue_current_site) {
            case 'en':
                // code...
                $link = home_url('category/blog');
                break;

            case 'fr':
                // code...
                $link = home_url('category/actualites');;
                break;
            
            default:
                // code...
                break;
        }

        return $link;
    }



    public  static function _getCertificationList()
    {
        // code...

        $output =  "";

        $params = array(
            'orderby' => 'ordre.meta_value ASC', 
            "limit" => -1,
        );

        // Nouvelle instance de pods
        $pods = pods("certification_des_produits", $params);
        if ($pods->total() > 0) {
            $output .= '<ul class="listLogoCertification">';
            while ($pods->fetch()) {
                if (empty($pods->display('logo'))) {
                    # code...
                    $img = get_template_directory_uri().'/assets/img/no-portrait@2x.png';
                }else{
                    $img = $pods->display('logo');
                }

                $title = $pods->display('name');
                $link = $pods->display('link');
               
                $output .= 
                    '   <li>
                            <a href="'.$link.'" target="_blank">
                                <img src="'.$img.'" alt="'.$title.'">
                            </a>
                        </li>
                    ';
            }
            $output .= '</ul>';
        }


        return $output;
    }


    public  static function _getCertificationListSingleProduct($idProduct)
    {
        // code...

        $output =  "";

        // get terms 
        $terms = get_the_terms( $idProduct, 'certification_des_produits' );
        if (!empty( $terms )) {
            // code...
        
            $output .= '<ul class="listLogoCertificationSingle">';
            foreach ($terms as $k_term) {
                // code...
                $imgCert = get_term_meta($k_term->term_id, 'logo', true );
                $linkCert = get_term_meta($k_term->term_id, 'link', true );
                $logo = $imgCert['guid'];
                //var_dump($linkCert);
                $output .= 
                '   <li>
                        <a href="'.$linkCert.'" target="_blank">
                            <img src="'.$logo.'" alt="'.$k_term->name.'">
                        </a>
                    </li>
                ';

                
            }

            $output .= '</ul>';
        }

        return $output;
    }



    public  static function _getCustomFieldProduct($idProduct, $field)
    {
        // code...
        $custom_fields = get_post_meta( $idProduct, $field, TRUE );
        if (!empty($custom_fields)) {
            // code...
            return $custom_fields;
        }else{
            return 0;
        }
             
    }

    



    public  static function _getProductRegion($idProduct)
    {
        // code...
        $terms = get_the_terms( $idProduct, 'regions_de_madagascar' );

        $output =  array();

        // get terms 
        
        if (!empty( $terms )) {
            // code...
        
            foreach ($terms as $k_term) {
                // code...
                $idregion = get_term_meta($k_term->term_id, 'id-cart-region', true );
                $output[] = array(
                    "id" => $idregion,
                    "value" => 0,
                    "region" => $k_term->name,
                );               

                
            }

        }

        return json_encode($output);         
    }




    public  static function _countProductRegion($idProduct)
    {
        // code...
        $terms = get_the_terms( $idProduct, 'regions_de_madagascar' );
        if (!empty($terms)) {
            // code...
            return count($terms);  
        }else{
            return 0;
        }
               
    }


    public static  function _getRegionIntervention()
    {
        # code...
        $terms = get_terms('regions_de_madagascar', array( 'hide_empty' => true, 'parent' => 0 ));

        $output =  array();

        // get terms 
        
        if (!empty( $terms )) {
            // code...
        
            foreach ($terms as $k_term) {
                // code...
                $idregion = get_term_meta($k_term->term_id, 'id-cart-region', true );
                $output[] = array(
                    "id" => $idregion,
                    "value" => 0,
                    "region" => $k_term->name,
                );               

                
            }

        }

        //var_dump($output);
        return json_encode($output); 
    }


    public  static function _getProductCategoryList()
    {
        // code...

        $outputCategory = "";
        $params = array(
            'orderby' => 'ordre.meta_value ASC', 
            "limit" => -1,
        );
        $pods =  pods("categories_des_produits", $params);

        
        if ($pods->total() > 0) {
            $outputCategory .= '<ol class="mainProductCategory">';
            while ($pods->fetch()) {
                // code...
                
                $id = $pods->display('ID');
                $img = $pods->display('image_categorie');
                $categoryTitle = $pods->display('name');
                $css = $pods->display('css_class');

                $link =  Sahanala::_getDynamicTranslatedURL('our-products');
                //var_dump($link); exit();
                //$link =  get_category_link($id);
                $outputCategory .= '
                    <li style="background-image: url('.$img.');">
                        <a href="'.$link.'"><span class="titleProducts '.$css.'">'.$categoryTitle.'</span></a>
                    </li>

                ';
            }
            $outputCategory .= '</ol>';
        }
        
        

        return $outputCategory;
    }


    public  static function _getProductsList()
    {
        // code...

        $outputProduct = "";
        $params = array(
            "limit" => -1,
        );
        $pods =  pods("products", $params);

        
        if ($pods->total() > 0) {
            $outputProduct .= '<ul class="productsHomeList">';
            while ($pods->fetch()) {
                // code...
                
                $id = $pods->display('ID');
                $product_title = $pods->display('title');

                $linkFull =  Sahanala::_getDynamicTranslatedURL('our-products');
                $link =  $linkFull."#".$pods->display('slug');
                //$link =  get_permalink($id);
                $outputProduct .= '
                    <li>
                        <a href="'.$link.'">'.$product_title.'</a>
                    </li>

                ';
            }
            $outputProduct .= '</ul>';
        }
        

        return $outputProduct;
    }


    public  static function _getProductsListSingle()
    {
        // code...

        $outputProduct = "";
        $params = array(
            "limit" => -1,
        );
        $pods =  pods("products", $params);

        
        if ($pods->total() > 0) {
            $outputProduct .= '<ul class="productsSingleList">';
            while ($pods->fetch()) {
                // code...
                
                $id = $pods->display('ID');
                $product_title = $pods->display('title');

                $link =  "#".$pods->display('slug');
                //$link =  get_permalink($id);
                $outputProduct .= '
                    <li>
                        <a href="'.$link.'" class="scrollTo">'.$product_title.'</a>
                    </li>

                ';
            }
            $outputProduct .= '</ul>';
        }
        

        return $outputProduct;
    }




    public static function _getPostByCategory($nbrePost, $cat_name)
    {
        $args = array( 'posts_per_page' => $nbrePost, 'category_name' => $cat_name );

        $actusHome = get_posts( $args );
       // var_dump($actusHome);
       $output = "";
       foreach ($actusHome as $post ){
            
            $category_detail = get_the_category($post->ID);
            $date = get_the_date('d F Y', $post->ID);
            if (has_post_thumbnail($post->ID)) {
                # code...
                $img_article = get_the_post_thumbnail_url($post->ID, "actus-home");
            }else{
                $img_article = esc_url( get_template_directory_uri() ).'/assets/img/placeholder.jpg';
            }

            $trimmed = wp_trim_words($post->post_content, 20, ' [...]');
                                
            
            $output .= '
                <div class="col-sm-6">
                    <div class="newsItem">
                        <a href="'.get_permalink($post->ID).'"><span class="img-news" style="background-image: url('.$img_article.');"></span></a>
                        <h5><a href="'.get_permalink($post->ID).'">'.$post->post_title.'</a></h5>
                        <p class="chapo">'.$trimmed.'</p>
                        <p>
                            <a href="'.get_permalink($post->ID).'" class="full-blog-btn">'.pll__("Full story").'</a>
                        </p>
                    </div>
                </div>
            ';

            
        }

        echo $output;

        wp_reset_postdata();
    }

   
    
    public  static function _getCareerList()
    {
        // code...

        $outputCareer = "";
        $params = array(
            "limit" => 9,
        );
        $pods =  pods("careers", $params);

        $argsPagination = array(
            'prev_next' => True,
            'prev_text' => __('&laquo;'),
            'next_text' => __('&raquo;'),
            'add_fragment' => '',
            'before_page_number' => '',
            'after_page_number' => '',
            'type' => 'list');
        
        if ($pods->total() > 0) {
            while ($pods->fetch()) {
                // code...
                
                $id = $pods->display('ID');
                $career_title = $pods->display('title');
                $trimmed = wp_trim_words($pods->display('job_description'), 20, ' [...]');
                
                $link =  get_permalink($id);
                $outputCareer .= '
                <div class="col-sm-4 jobList">
                    <div class="newsItem">
                        <h5><a href="'.$link.'">'.$career_title.'</a></h5>
                        <p class="chapo">'.$trimmed.'</p>
                        <p>
                            <a href="'.$link.'" class="full-blog-btn">'.pll__("Learn more").'</a>
                        </p>
                    </div>
                </div>
                ';
            }


            $outputCareer .= '
            <div class="col-12">
                <div class="paginateResult">
                    '.$pods->pagination( $argsPagination ).'
                </div>
            </div>
            ';
            
        }
        

        return $outputCareer;
    }
    


    public static function dd($value='')
    {
        # code...
        echo "<pre>";
        var_dump($value);
        echo "</pre>";
    }


    public static function sky_date_french($format, $timestamp = null, $echo = null) {
        $param_D = array('', 'Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam', 'Dim');
        $param_l = array('', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi', 'Dimanche');
        $param_F = array('', 'Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre');
        $param_M = array('', 'Jan', 'Fév', 'Mar', 'Avr', 'Mai', 'Jun', 'Jul', 'Aoû', 'Sep', 'Oct', 'Nov', 'Déc');
        $return = '';
        if(is_null($timestamp)) { $timestamp = mktime(); }
        for($i = 0, $len = strlen($format); $i < $len; $i++) {
            switch($format[$i]) {
                case '\\' : // fix.slashes
                    $i++;
                    $return .= isset($format[$i]) ? $format[$i] : '';
                    break;
                case 'D' :
                    $return .= $param_D[date('N', $timestamp)];
                    break;
                case 'l' :
                    $return .= $param_l[date('N', $timestamp)];
                    break;
                case 'F' :
                    $return .= $param_F[date('n', $timestamp)];
                    break;
                case 'M' :
                    $return .= $param_M[date('n', $timestamp)];
                    break;
                default :
                    $return .= date($format[$i], $timestamp);
                    break;
            }
        }
        if(is_null($echo)) { return $return;} else { echo $return;}
    }



    

  

    /**
     * Affichage du résultat de la recherche
     * @method SearchResult
     * @return void
     */
    public static function SearchResult() {
        global $query_string;
        global $wp_query;

        $query_args = explode("&", $query_string);
        $search_query = array();

        foreach($query_args as $key => $string) {
            $query_split = explode("=", $string);
            $search_query[$query_split[0]] = urldecode($query_split[1]);
        } // foreach

        $search = new WP_Query($search_query);

        $output = '<div class="searchForm">';
        $output .= get_search_form();
        $output .= '<p><b>' . $wp_query->found_posts . '</b> ' . __("Resultats trouvés", "Fitia") . '</p></div>';

        foreach($search as $key => $value) {
            the_post();

            if (get_the_title()) {
                $output .= '<div class="searchResult">';
                $output .= '<h1><a href="' . get_permalink(get_the_ID()) . '">' . get_the_title() . '</a></h1>
                    <p>' . wp_trim_words(get_the_content(), 30, " [...]") . '</p><p>
                        <a href="' . get_permalink(get_the_ID()) . '" class="btn-standard-border">Découvrir</a>
                    </p><hr></div>';
            }
        }

        $args = array(
            'prev_next'          => True,
            'prev_text'          => __('&laquo;'),
            'next_text'          => __('&raquo;'),
            'add_fragment'       => '',
            'before_page_number' => '',
            'after_page_number'  => '',
            'type'=> 'list'
        );
        $output .= '<div class="paginateResult">';
        $output .= paginate_links($args);
        $output .= '</div>';

        echo $output;
    }




   

    /**
     * Breadcrumb pour la recherche
     * @method _RenderBreadCrumb
     * @return void
     */
    public static function _RenderBreadCrumb() {
        global $post;

        if (!is_home()) {
            echo '<li><a href="' .home_url() . '">' . pll__("Home page") . '</a></li>';

            $parents = get_post_ancestors( $post->ID );
            foreach($parents as $parent){
                echo '<li><a href="' . get_permalink($parent) . '">' . get_the_title($parent) . '</a></li>';
            }

            if (is_page()) {
                echo '<li class="active">' . get_the_title() . '</li>';
            }

            $post = get_post(get_the_ID());

            //var_dump($post);

            if (is_single()) {
                if ($post->post_type == 'courtage') {
                    # code...
                    echo '<li><a href="' .home_url() . '/">' . pll__("Home") . '</a></li>';
                    echo '<li class="active">' . get_the_title() . '</li>';

                }

                if ($post->post_type == 'products') {
                    # code...
                    echo '<li class="active">' . pll__("Our Products") . '</li>';
                }
                
            }
        }
    }


    public static function the_categories_sans_lien() {
        // get all categories for this post
        $i = 0;$sep = ', ';
        $cats = '';
        foreach ( ( get_the_category() ) as $category ) { 
            if (0 < $i) $cats .= $sep; $cats .= $category->cat_name; $i++;
        }
        echo $cats;
    }

}
