<?php

/**
 * Class Features
 * Implémentation des fonctionnalités supportés par le thème
 */
class Features {
    public function __construct() {
        
        // Load language

        add_action("after_setup_theme", array($this, "loadLanguage"));

        add_action('after_setup_theme',array($this, 'wpc_theme_support'));

        add_action('customize_register', array($this, 'wpc_customize_register'));


        //add_action( 'admin_enqueue_scripts', 'admin_script_joh' );



        // Post thumbnail
        add_theme_support("post-thumbnails");

        // Suppression du margin dans header si on est connecté
        //add_action("get_header", array($this, "removeAdminHeader"));

        // Ajout de menus
        add_action( "init", array($this, "registerMenu"));

        
        
        add_action('init',array($this, "imagesizeperso"));
        
        //add_action('init',array($this, "enqueue_theme_styles"));

        //add_filter( 'init', array($this, 'wpdocs_excerpt_more' ));
        
        //add_filter( 'init', array($this, 'wpdocs_custom_excerpt_length' ));



        //add_action( $tag, $function_to_add, 10, 1 );

        // add_action('init',array($this, "jsregister"));


        
        
    }

    /**
     * Suppression du margin dans header si on est connecté
     */
    public function removeAdminHeader() {
        //remove_action("wp_head", "_admin_bar_bump_cb");
    }




    /*public function wpdocs_custom_excerpt_length( $length = 55 ) {    
        if( $post->post_excerpt ) {
            $content = get_the_excerpt();
        } else {
            $content = get_the_content();
            $content = wp_trim_words( $content , $length );
        }
        return $excerpt;
    }




    public function wpdocs_excerpt_more( $more ) {
        return '[...]';
    }*/

        

    public function remove_accent($str)
    {
      $a = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð',
                    'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã',
                    'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ',
                    'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ',
                    'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę',
                    'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī',
                    'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ',
                    'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ',
                    'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 
                    'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 
                    'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ',
                    'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');

      $b = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O',
                    'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c',
                    'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u',
                    'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D',
                    'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g',
                    'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K',
                    'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o',
                    'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S',
                    's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W',
                    'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i',
                    'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
      return str_replace($a, $b, $str);
    }


    /* Générateur de Slug (Friendly Url) : convertit un titre en une URL conviviale.*/
    public function doslug($str){
      return mb_strtolower(preg_replace(array('/[^a-zA-Z0-9 \'-]/', '/[ -\']+/', '/^-|-$/'),
      array('', '-', ''), $this->remove_accent($str)));
    }


    /**
     * Implémentation des menus du thème
     */
    public function registerMenu() {
        register_nav_menu("main-menu", __("Main Menu"));
        register_nav_menu("menu-footer-1", __("Menu Footer 1"));
        register_nav_menu("menu-footer-2", __("Menu Footer 2"));
        register_nav_menu("menu-footer-3", __("Menu Footer 3"));
    }

    public function loadLanguage() {
        //load_theme_textdomain('smarthexa', get_template_directory() . '/languages');
    }



    public function imagesizeperso() { 
        add_image_size( 'actus-home', 330, 210, true); /* Taille perso  1 */ 
        add_image_size( 'actus', 278, 185, true); /* Taille perso  1 */ 
        add_image_size( 'spots', 700, 220, true); /* Taille perso  1 */ 
        add_image_size( 'cat-thumb', 278, 185); /* Taille perso  1 */ 
        add_image_size( 'single-thumb', 750, 440, true ); /* Taille perso  2 */
        add_image_size( 'slider', 1920, 764, true );  /* Taille perso  3 */
        add_image_size( 'very-xs', 95, 95, true );  /* Taille perso  3 */
        add_image_size( 'very-small', 95, 95, true );  /* Taille perso  3 */ 
    }


    public function wpc_theme_support() {
        add_theme_support('custom-logo', array(
            'flex-height' => true,
            'flex-width'  => true,
        ));
    }



    public function wpc_customize_register($wp_customize) {
        $wp_customize->add_section('wpc_logo_section', array(
                'title'          => __('Logo', 'textdomain'),
                'priority'       => 30,
                'description'    => __('Upload a logo to replace the default site name and description in the header', 'textdomain')
            )
        );
        $wp_customize->add_setting('wpc_logo');
        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'wpc_logo', array(
                'label'      => __('Logo', 'textdomain'),
                'section'    => 'wpc_logo_section',
                'settings'   => 'wpc_logo')
            )
        );
    }



    


  

    
}

// Instanciation de la classe
new Features();
