<!DOCTYPE html>
<html lang="<?php get_bloginfo('language') ?>">
<head>

	<title>
	      <?php bloginfo('name'); ?> | <?php is_front_page() ? bloginfo('description') : wp_title(''); ?>
	</title>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	  <meta name=description content="<?php if ( is_single() ) {
	      single_post_title('', true);
	  } else {
	      bloginfo('name'); echo " - "; bloginfo('description');
	  }
	  ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name=viewport content="width=device-width, initial-scale=1">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">

	<meta name="google-site-verification" content="3jP3GC3-YmEiZHsROqw0HED-_OvICcZZZrzjK5XlQEE" />
	
	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="<?= esc_url( get_template_directory_uri() ); ?>/assets/css/bootstrap.min.css">

	<!-- Fontawesome CSS -->
	<link rel="stylesheet" href="<?= esc_url( get_template_directory_uri() ); ?>/assets/css/all.min.css">
	
	<!-- animate CSS -->
	<link rel="stylesheet" href="<?= esc_url( get_template_directory_uri() ); ?>/assets/css/animate.min.css">


	<?php $filetimeCssLayout = filemtime( get_template_directory(). '/assets/css/sahanala.min.css'); ?>
	   
	<!-- Layout CSS -->
	<link rel="stylesheet" href="<?= esc_url( get_template_directory_uri() ); ?>/assets/css/sahanala.min.css?version=<?php echo $filetimeCssLayout; ?>">
		
	<!-- theme bar -->
	<meta name="theme-color" content="#50b732">

	<?php wp_head(); ?>
</head>
<body>
	<header>
		<div class="container">
			<div class="row">
				<div class="col-sm-3 logo">
					<?php Sahanala::_getLogoSite(); ?>
				</div>

				<div class="col-sm-6">
					<button type="button" id="menuToogler" class="d-block d-sm-none">
						<i class="fas fa-bars"></i>
					</button>
					<nav class="mainMenu">
						<?php wp_nav_menu( array( 'container' => 'ul', 'theme_location' => 'main-menu', 'menu_class' => '') ); ?>
					</nav>
				</div>

				<div class="col-md-3 d-none d-sm-block">
					<div class="row">
						<div class="col-sm-6">
							<ul class="langue_chooser">
								<?php pll_the_languages();?>
								<div class="listLangueDispo">
									<?php pll_the_languages();?> 
								</div>
							</ul>
							
						</div>

						<div class="col-sm-6">
							<a href="<?= Sahanala::_getDynamicTranslatedURL('contact-us'); ?>" class="contactHeader"><?= pll__("Contact us"); ?></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</header>