
<?php
/*
Template Name: SAHANALA - Home page Dynamique
*/
?>
<?php get_header(); ?>

<div id="slider" style="background-image: url('<?= Sahanala::_getHomeContent('image_slider'); ?>');" class="sectionPage">
			<div class="container">
				<div class="caption col-sm-3">
					<h2><?= Sahanala::_getHomeContent('titre_slider'); ?></h2>
				</div>
			</div>
		</div>
		<div id="about" class="sectionPage">
			<div class="container">
				<div class="row">
					<div class="col-sm-5">
						<p><span class="subtitle"><?= pll__("About Us"); ?></span></p>
						<?= Sahanala::_getHomeContent('bloc_about'); ?>
						<p>
							<a href="<?= Sahanala::_getDynamicTranslatedURL('about-us'); ?>" class="sahanala-btn outline-blue-btn"><?= pll__("Learn more"); ?></a>
							<a href="<?= Sahanala::_getDynamicTranslatedURL('contact-us'); ?>" class="sahanala-btn green-btn"><?= pll__("Contact Us"); ?></a>
						</p>
					</div>
					<div class="col-sm-7">
						<ul class="randomImg">
							<li>
								<img src="<?= Sahanala::_getHomeContent('image_about_1'); ?>" alt="sahanala">
							</li>
							<li>
								<img src="<?= Sahanala::_getHomeContent('image_about_2'); ?>" alt="sahanala">
							</li>
							<li>
								<img src="<?= Sahanala::_getHomeContent('image_about_3'); ?>" alt="sahanala">
							</li>
							<li>
								<img src="<?= Sahanala::_getHomeContent('image_about_4'); ?>" alt="sahanala">
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>


		<div id="sustainable" class="sectionPage">
			<span class="bgSustainable" style="background-image: url('<?= Sahanala::_getHomeContent('image_approche'); ?>');"></span>
			<div class="container caption-sustainable">
				<div class="row">
					<div class="col-sm-6 p-5">
						<p><span class="subtitle"><?= pll__("About Us"); ?></span></p>
						<h3><?= pll__("Inclusive approach for sustainable impacts"); ?><span>.</span></h3>
						<div class="stat row">
							<div class="col-sm-6 item-stat">
								<i class="icon-stat producers"></i>
								<h5><?= Sahanala::_getHomeContent('value_producer'); ?></h5>
								<p><?= pll__("Producers"); ?></p>
							</div>
							<div class="col-sm-6 item-stat">
								<i class="icon-stat associations"></i>
								<h5><?= Sahanala::_getHomeContent('value_associations'); ?></h5>
								<p><?= pll__("Associations"); ?></p>
							</div>
							<div class="col-sm-6 item-stat">
								<i class="icon-stat federations"></i>
								<h5><?= Sahanala::_getHomeContent('value_federations'); ?></h5>
								<p><?= pll__("Federations"); ?></p>
							</div>
							<div class="col-sm-6 item-stat">
								<i class="icon-stat madagascar"></i>
								<h5><?= Sahanala::_getHomeContent('value_regions'); ?></h5>
								<p><?= pll__("Regions"); ?></p>
							</div>
						</div>
					</div>
					<div class="col-sm-6 p-5">
						<?= Sahanala::_getHomeContent('bloc_approach'); ?>
						<p>
							<a href="<?= Sahanala::_getDynamicTranslatedURL('about-us'); ?>" class="sahanala-btn outline-white-blue-btn"><?= pll__("Learn more"); ?></a>
						</p>
					</div>
				</div>
			</div>
		</div>



		<div id="products" class="sectionPage">
			<div class="container text-center">
				<div class="row">
					<div class="col-sm-8 offset-sm-2">
						<p><span class="subtitle"><?= pll__("Our Products"); ?></span></p>
						<h3><?= Sahanala::_getHomeContent('title_product'); ?><span>.</span></h3>
						<p><?= Sahanala::_getHomeContent('intro_product'); ?></p>
					</div>
				</div>

				<div class="row">
					<div class="col-12">
						<?=  Sahanala::_getProductCategoryList(); ?>
					</div>
				</div>


				<div class="row">
					<div class="col-12 mt-5">
						<h5 class="mt-5"><?= pll__("Full list of our products"); ?></h5>
					</div>
					<div class="col-12">
						<?=  Sahanala::_getProductsList(); ?>
					</div>
				</div>
				
			</div>
		</div>


		<div id="tourisme" class="sectionPage">
			<div class="container">
				<div class="cover-tourisme">
					<span class="cover-img-tourisme" style="background-image: url('<?= Sahanala::_getHomeContent('image_tourisme'); ?>');"></span>
					<div class="row">
						<div class="col-sm-6">
							<p><span class="subtitle"><?= Sahanala::_getHomeContent('title_tourisme'); ?></span></p>
							<h3><?= Sahanala::_getHomeContent('intro_tourisme'); ?><span>.</span></h3>
						</div>
						<div class="col-sm-6">
							<?= Sahanala::_getHomeContent('bloc_tourism'); ?>
							

							<p>
								<a href="<?= Sahanala::_getDynamicTranslatedURL('tourism'); ?>" class="sahanala-btn outline-blue-btn"><?= pll__("Learn more"); ?></a>
								<a href="https://akiba-lodge.mg/" class="sahanala-btn marron-btn">Ankiba Lodge <i class="fas fa-external-link-alt ml-2"></i></a>
							</p>
						</div>
					</div>
				</div>
			</div>
			<span class="cover-img-tourisme-after" style="background-image: url('<?= Sahanala::_getHomeContent('image_tourisme_2'); ?>');"></span>
		</div>
		

		<div id="news-certification"  class="sectionPage">
			<div class="container">
				<div class="row">
					<div class="col-sm-6 offset-sm-3 text-center">
						<p><span class="subtitle"><?= pll__("Blog"); ?></span></p>
						<h3><?= pll__("News and updates"); ?><span>.</span></h3>
						<p><?= pll__("Featured stories across the Sahanala family of collaborators, funds, communities and programs."); ?></p>
					</div>
				</div>

				<div class="row mt-5 mb-5">
					<?php Sahanala::_getPostByCategory(4, 'blog') ?>

					<p class="col-12 text-center mb-5">
						<a href="<?= Sahanala::_getBlogUrl(); ?>" class="sahanala-btn outline-blue-btn"><?= pll__("All Our Stories"); ?></a>
					</p>
				</div>
				
			</div>

			<div class="container">
				<div class="row mt-5">
					<div class="col-sm-6 offset-sm-3 text-center mt-5">
						<h3><?= pll__("OUR CERTIFICATIONS"); ?></h3>
					</div>
				</div>

				<div class="row">
					<div class="col-12">
						<?= Sahanala::_getCertificationList(); ?>
					</div>
				</div>
			</div>
		</div>

		
<?php get_footer(); ?>