<?php
/*
Template Name: SAHANALA - Home page 
*/
?>
<?php get_header(); ?>
<div id="slider" style="background-image: url('<?= esc_url( get_template_directory_uri() ); ?>/assets/img/cover-sample.jpg');" class="sectionPage">
			<div class="container">
				<div class="caption col-sm-3">
					<h2><span>Valuing</span> the lives and activities of local communities<b>.</b></h2>
				</div>
			</div>
		</div>
		<div id="about" class="sectionPage">
			<div class="container">
				<div class="row">
					<div class="col-sm-5">
						<p><span class="subtitle">About Us</span></p>
						<h3>Supporting and strengthening of local communities<span>.</span></h3>
						<p>Sahanala was created in 2010 by Fanamby, a non-profit association <b>managing 4 Category V protected areas, and a natural monuments</b> in Madagascar. The main objective is to support and strengthen the capacities of local communities by <b>professionalizing them and integrating them into a federation strong enough</b> to face international markets, and support conservation activities like biodiversity in their regions.</p>
						<p>
							<a href="<?= Sahanala::_getDynamicTranslatedURL('about-us'); ?>" class="sahanala-btn outline-blue-btn"><?= pll__("Learn more"); ?></a>
							<a href="<?= Sahanala::_getDynamicTranslatedURL('contact-us'); ?>" class="sahanala-btn green-btn"><?= pll__("Contact Us"); ?></a>
						</p>
					</div>
					<div class="col-sm-7">
						<ul class="randomImg">
							<li>
								<img src="<?= esc_url( get_template_directory_uri() ); ?>/assets/img/random/1.jpg" alt="">
							</li>
							<li>
								<img src="<?= esc_url( get_template_directory_uri() ); ?>/assets/img/random/2.jpg" alt="">
							</li>
							<li>
								<img src="<?= esc_url( get_template_directory_uri() ); ?>/assets/img/random/3.jpg" alt="">
							</li>
							<li>
								<img src="<?= esc_url( get_template_directory_uri() ); ?>/assets/img/random/4.jpg" alt="">
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>


		<div id="sustainable" class="sectionPage">
			<span class="bgSustainable" style="background-image: url('<?= esc_url( get_template_directory_uri() ); ?>/assets/img/cover-development.jpg');"></span>
			<div class="container caption-sustainable">
				<div class="row">
					<div class="col-sm-6 p-5">
						<p><span class="subtitle">About Us</span></p>
						<h3>Inclusive approach for sustainable impacts<span>.</span></h3>
						<div class="stat row">
							<div class="col-sm-6 item-stat">
								<i class="icon-stat producers"></i>
								<h5>+12<span>.</span>000</h5>
								<p><?= pll__("Producers"); ?></p>
							</div>
							<div class="col-sm-6 item-stat">
								<i class="icon-stat associations"></i>
								<h5>92</h5>
								<p><?= pll__("Associations"); ?></p>
							</div>
							<div class="col-sm-6 item-stat">
								<i class="icon-stat federations"></i>
								<h5>4</h5>
								<p><?= pll__("Federations"); ?></p>
							</div>
							<div class="col-sm-6 item-stat">
								<i class="icon-stat madagascar"></i>
								<h5>12</h5>
								<p><?= pll__("Regions"); ?></p>
							</div>
						</div>
					</div>
					<div class="col-sm-6 p-5">
						<p>We give farmers the opportunity to <b>participate actively in the development</b> of their locality, and in the protection of their environment. By providing them with a more stable income, and by teaching them good practices such as organic farming and respect for the environment, we are helping to improve the lives of local communities in a sustainable manner. We support them technically, materially, and socially.</p>
						<img src="<?= esc_url( get_template_directory_uri() ); ?>/assets/img/producteurs-rice.jpg" class="img-responsive">
						<p>
							<a href="<?= Sahanala::_getDynamicTranslatedURL('about-us'); ?>" class="sahanala-btn outline-white-blue-btn"><?= pll__("Learn more"); ?></a>
						</p>
					</div>
				</div>
			</div>
		</div>



		<div id="products" class="sectionPage">
			<div class="container text-center">
				<div class="row">
					<div class="col-sm-8 offset-sm-2">
						<p><span class="subtitle"><?= pll__("Our Products"); ?></span></p>
						<h3>4 Types of products to transform our communities<span>.</span></h3>
						<p>Our objective is to <b>enhance the activities of farmers</b> by providing them with the necessary elements for responsible farming, and thus obtaining quality products.</p>
					</div>
				</div>

				<div class="row">
					<div class="col-12">
						<?=  Sahanala::_getProductCategoryList(); ?>
					</div>
				</div>


				<div class="row">
					<div class="col-12 mt-5">
						<h5 class="mt-5"><?= pll__("Full list of our products"); ?></h5>
					</div>
					<div class="col-12">
						<?=  Sahanala::_getProductsList(); ?>
					</div>
				</div>
				
			</div>
		</div>


		<div id="tourisme" class="sectionPage">
			<div class="container">
				<div class="cover-tourisme">
					<span class="cover-img-tourisme" style="background-image: url('<?= esc_url( get_template_directory_uri() ); ?>/assets/img/cover-tourisme.jpg');"></span>
					<div class="row">
						<div class="col-sm-6">
							<p><span class="subtitle">Tourism for conservation</span></p>
							<h3>Tourism for conservation: Alternative and development lever for local communities<span>.</span></h3>
						</div>
						<div class="col-sm-6">
							<p>Since the foundation stone was laid in 2007 in Anjozorobe where our journey began, our establishments have always had the vocation of promoting sustainable tourism as an economic alternative and lever for the development of local communities. Their involvement in conservation actions is essential for lasting results. The inclusion and participatory approach that we advocate aims to build capacity at the local level. <b>Nearly 1.000 members</b> make up our Tourism federation, the majority of whom are women dedicated to providing an original experience to each of our guests.</p>

							<p>
								<a href="<?= Sahanala::_getDynamicTranslatedURL('tourism'); ?>" class="sahanala-btn outline-blue-btn"><?= pll__("Learn more"); ?></a>
							<a href="https://akiba-lodge.mg/" class="sahanala-btn marron-btn">Ankiba Lodge <i class="fas fa-external-link-alt ml-2"></i></a>
							</p>
						</div>
					</div>
				</div>
			</div>
			<span class="cover-img-tourisme-after" style="background-image: url('<?= esc_url( get_template_directory_uri() ); ?>/assets/img/cover-baobab.jpg');"></span>
		</div>
		

		<div id="news-certification"  class="sectionPage">
			<div class="container">
				<div class="row">
					<div class="col-sm-6 offset-sm-3 text-center">
						<p><span class="subtitle"><?= pll__("Blog"); ?></span></p>
						<h3><?= pll__("News and updates"); ?><span>.</span></h3>
						<p><?= pll__("Featured stories across the Sahanala family of collaborators, funds, communities and programs."); ?></p>
					</div>
				</div>

				<div class="row mt-5 mb-5">
					<?php Sahanala::_getPostByCategory(4, 'blog') ?>

					<p class="col-12 text-center mb-5">
						<a href="#" class="sahanala-btn outline-blue-btn"><?= pll__("All Our Stories"); ?></a>
					</p>
				</div>
				
			</div>

			<div class="container">
				<div class="row mt-5">
					<div class="col-sm-6 offset-sm-3 text-center mt-5">
						<h3><?= pll__("OUR CERTIFICATIONS"); ?></h3>
					</div>
				</div>

				<div class="row">
					<div class="col-12">
						<?= Sahanala::_getCertificationList(); ?>
					</div>
				</div>
			</div>
		</div>

		
<?php get_footer(); ?>