<?php
/*
Template Name: SAHANALA - Products page 
*/
?>
<?php get_header(); ?>
<div id="bannerTitle" <?php if ( has_post_thumbnail() ) : ?> style="background-image: url(<?php the_post_thumbnail_url(); ?>);" <?php else :  ?> style="background-image: url(<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/cover-default.jpg);"<?php endif; ?>>
    <div class="container">
        <h1><?php the_title(); ?></h1>
        <div class="breadcrumb-sahanala">
            <ul>
                <?php Sahanala::_RenderBreadCrumb(); ?>
            </ul>
        </div>
    </div>
</div>

<div id="internalPage" class="container-fluid singleProduct">
    <div class="container mb-5 pb-5">
        <div class="row">
            <div class="col-sm-8">
                <div class="row">
                    <div class="col-sm-8">
                         <?php if (have_posts()) : ?>
                            <?php while (have_posts()) : the_post(); ?>
                                <?php the_content(); ?>
                            <?php endwhile; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-12">
                        <h5 class="caption_product"><?= pll__("Caption"); ?></h5>
                        <?php echo  Sahanala::_getProductsListSingle(); ?>
                    </div>
                </div>
            </div>

            <div class="col-sm-4">
               <!--  <span class="mapMadagascar"></span> -->
               <?php Sahanala::_getRegionIntervention(); ?>
               <script>
                   var _dataMapIntervention = '<?= Sahanala::_getRegionIntervention(); ?>';
               </script>
               <div id="generalMapProduct"></div>
            </div>
        </div>

        
    </div>
    
</div>

<div id="productBoxListContainer">
    <div class="container">
        <div class="row">
            <?php 

                $args = array(  
                    'post_type' => 'products',
                    'post_status' => 'publish',
                    'posts_per_page' => -1, 
                    'orderby' => 'title', 
                    'order' => 'ASC', 
                );

                $products = new WP_Query( $args ); 

                

             ?>
            <?php  while ( $products->have_posts() ) : $products->the_post();  ?>
                    
                <?php //var_dump($post); exit();?>
                <div class="col-sm-6">
                    <div class="boxProduit" id="<?= $post->post_name; ?>">
                        <div class="cover" <?php if ( has_post_thumbnail($post->ID) ) : ?> style="background-image: url(<?= get_the_post_thumbnail_url($post->ID); ?>);" <?php else :  ?> style="background-image: url(<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/blog-cover.jpg);"<?php endif; ?>></div>
                        <div class="product-details-content">
                            <h4><?= $post->post_title; ?></h4>
                            <?= $post->post_content; ?>
                        </div>  

                        <div class="products-stat">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div id="products-map-<?= $post->ID; ?>" data-product-id="<?= $post->ID; ?>" class="chart-shadow" style="height:315px" map-data='<?= Sahanala::_getProductRegion($post->ID); ?>'></div>
                                </div>
                                <div class="col-sm-8">
                                    <div class="stat row">
                                        <div class="col-sm-6 item-stat">
                                            <h5><?= Sahanala::_countProductRegion($post->ID); ?></h5>
                                            <p><?= pll__("Regions"); ?></p>
                                        </div>
                                        
                                        <div class="col-sm-6 item-stat">
                                            <h5><?= Sahanala::_getCustomFieldProduct($post->ID, "nombre_association"); ?></h5>
                                            <p><?= pll__("Associations"); ?></p>
                                        </div>

                                        <div class="col-sm-6 item-stat">
                                            <h5><?= Sahanala::_getCustomFieldProduct($post->ID, "nombre_employees"); ?></h5>
                                            <p><?= pll__("Employees"); ?></p>
                                        </div>

                                        <div class="col-sm-6 item-stat">
                                            <h5><?= Sahanala::_getCustomFieldProduct($post->ID, "nombre_producteurs"); ?></h5>
                                            <p><?= pll__("Producers"); ?></p>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="product-label">
                            <?= Sahanala::_getCertificationListSingleProduct($post->ID); ?>
                        </div>
                    </div>
                </div>
            <?php  endwhile; wp_reset_postdata();  ?>
        </div>
    </div>
</div>
<?php get_footer(); ?>