
<?php get_header(); ?>
<div id="bannerTitle" <?php if ( has_post_thumbnail() ) : ?> style="background-image: url(<?php the_post_thumbnail_url(); ?>);" <?php else :  ?> style="background-image: url(<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/cover-default.jpg);"<?php endif; ?>>
    <div class="container">
        <h1><?= pll__("Our Products"); ?></h1>
        <div class="breadcrumb-sahanala">
            <ul>
                <?php Sahanala::_RenderBreadCrumb(); ?>
            </ul>
        </div>
    </div>
</div>

<div id="internalPage" class="container-fluid singleProduct">
    <div class="container">
        <div class="row">
            <div class="col-sm-8">
                <div class="row">
                    <div class="col-sm-8">
                        <h3>Our objective is to enhance the activities of farmers</h3>
                        <p>By providing them with the necessary elements for responsible farming, and thus obtaining quality products. All means are mobilized so that these products follow the standards required by the international market.</p>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-12">
                        <h5><?= pll__("Caption"); ?></h5>
                        <?php echo  Sahanala::_getProductsListSingle(); ?>
                    </div>
                </div>
            </div>

            <div class="col-sm-4">
                <span class="mapMadagascar"></span>
            </div>
        </div>

        <?php if (have_posts()) : ?>
            <?php while (have_posts()) : the_post(); ?>
            <div class="row">
                <div class="boxProduit col-sm-8">
                    <div class="cover" <?php if ( has_post_thumbnail() ) : ?> style="background-image: url(<?php the_post_thumbnail_url('banner'); ?>);" <?php else :  ?> style="background-image: url(<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/cover-default.jpg);"<?php endif; ?>></div>
                    <div class="product-details-content">
                        <h4><?php the_title(); ?></h4>
                        <?php the_content(); ?>
                    </div>  

                    <div class="products-stat">
                        <div class="row">
                            <div class="col-sm-4">

                                <div id="product-map-single" class="chart-shadow" map-data='<?= Sahanala::_getProductRegion(get_the_ID()); ?>' style="height:315px"></div>
                            </div>
                            <div class="col-sm-8">
                                <div class="stat row">
                                    <div class="col-sm-6 item-stat">
                                        <h5><?= Sahanala::_countProductRegion(get_the_ID()); ?></h5>
                                        <p><?= pll__("Regions"); ?></p>
                                    </div>
                                    
                                    <div class="col-sm-6 item-stat">
                                        <h5><?= Sahanala::_getCustomFieldProduct(get_the_ID(), "nombre_association"); ?></h5>
                                        <p><?= pll__("Associations"); ?></p>
                                    </div>

                                    <div class="col-sm-6 item-stat">
                                        <h5><?= Sahanala::_getCustomFieldProduct(get_the_ID(), "nombre_employees"); ?></h5>
                                        <p><?= pll__("Employees"); ?></p>
                                    </div>

                                    <div class="col-sm-6 item-stat">
                                        <h5><?= Sahanala::_getCustomFieldProduct(get_the_ID(), "nombre_producteurs"); ?></h5>
                                        <p><?= pll__("Producers"); ?></p>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="product-label">
                        <?= Sahanala::_getCertificationListSingleProduct(get_the_ID()); ?>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        <?php endif; ?>
    </div>
    
</div>
<?php get_footer(); ?>